/// librairies
import processing.sound.*;

// variables globales
SoundFile son; // un son

float ang = 50;
float x = 0;
float y = 0;
float deg = 0;
float degacc = 0;
float acc = 0;
float angle = 0.0;

int[] angs = {15, 18, 20, 24, 30, 36, 40, 45, 60, 72, 90, 120};
PImage img;

int count = 0;
int count2 =0;

PFont font;
String s = "La Liberazione Di Ruggiero Dall Isola Di Alcina";


// ==================== Partie 1: Énumérer des éléments dans l'affiche

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// variables liées à l'animation
boolean anim_active_1 = false;
boolean anim_active_2 = false;
   
   
   
// ==================== Partie 2: setup les libraries pour les éléments
   
void setup() {
  init2();
  size(1270, 700);
  //fullScreen(); 
  noStroke();
  font = createFont("AltoPro-SemiBold",30); 
  textFont(font);
  
  // initialisation des variables globales son
  
  // chargement du son
  son = new SoundFile(this, "sons/123_2m.mp3");
  //println(son.duration());

  
  img = new PImage();
}


// ==================== Partie 3: setup les gestions de mouvement
   
void draw() { 
 
  // gestion du son ////////////////////////////////////////
  // test du temps pendant lequel le son est joué
  //debug
  println("son_actif = "+ son_actif);
  // fin debug
  
  if (son_actif){
    float tempsEcoute = millis() - tempsDebutSon ;

   // debug 
    println("tempsDebutSon = " + tempsDebutSon);
    println("tempsEcoute = " + tempsEcoute);
    println("durée du son " + son.duration());
    // fin debug
    
    if ( tempsEcoute >= son.duration()*1000){ // si le son est fini
      son_actif = false; // bouton son_actif off
    }
  }
  
    
     // gestion de la animation ///////////////////////////////////
     if (anim_active_1){
       fill(20);
       translate(width /2, height / 2);
  
       image(img, -50, -50);
       image(img, -50, -50, 100, 100);
  
       for(int i = 0; i < 360; i += ang){
         subdraw();
         rotate(radians(ang));
       }
  
       x += cos(radians(deg)) * 3;
       y += sin(radians(deg)) * 3;
       deg += degacc;
       degacc -= acc;
       acc += 0.001;
  
       count++;
       if(count >= 20){
         count = 0;
         init1();
         count2++;
       }
     }
   
          // gestion de la animation du text ///////////////////////////////////
      if (anim_active_2){
        fill(0,10);
        angle += 0.1;
        for (int i = 0; i < s.length (); i++) {
        float c = sin(angle + i/PI);
        float y=((c + 4.0) * 50 + 1); // C + La position de ligne*la hauteur d'onde + ??
        text(s.charAt(i), i*25+80, y+150);// i*La chase de ligne + ???
   }
  } 
}

// ==================== Partie 4: setup le clavier pour commencer les mouvements
void keyPressed() {
  
  ////////////////////////++++++++++++++================
  if (key == CODED) {
    if (keyCode == RIGHT) { // son
      if (son_actif == false){ // le son ne joue pas
        son_actif = !son_actif; // bouton son_actif on
        son.play();
        tempsDebutSon = millis();
      }
      else { 
        son.stop(); //
        son_actif = false;
        son_actif = !son_actif;
        son.play();
      }
    }
    ////////////////////////++++++++++++++================
    
    
    if (keyCode == UP) { // sketch processing typo
       if (anim_active_2 == false){ // si animactive2 est "false" et qu'il y a déjà un dessin (anim activ1)
         anim_active_1 = false; //arrêter animation 1
         background(255); // effacer le fond
         
       }
       anim_active_2 = !anim_active_2; // lorsqu'on appuye sur UP changer l'état de la variable anim_activ2 (true<->false)
       
        
    }
    ////////////////////////++++++++++++++================
    
    if (keyCode == LEFT) { // sketch processing spiral  
      if (anim_active_1 == false){ // si annimation 1 est arrêtée
        {
        anim_active_2 = false; //arrêter animation 2
        init2();// effacer le fond
         }   
        ang = angs[(int)random(angs.length - 1)];
        println(ang);    
      }
        anim_active_1 = !anim_active_1; // ! means refresh, false means stop
      
    }
    
    if (keyCode == DOWN) {
      son.stop();
      anim_active_1 = false;
      anim_active_2 = false;
      son_actif = false;
      init2();
    }
  } 
}


void subdraw(){
  ellipse(x, y, 5, 5);
}
void init1(){
  deg = random(360);
  degacc = random(1) - 1;
  acc = random(1) - 1;
}

void init2(){
  init1();
  x = 0;
  y = 0;
  background(255);
}
 